/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unicom.util;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.iam.IamUserUtil;
import com.elitesland.cbpl.unicom.adapter.UnicomAdapter;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.cbpl.unicom.context.Customize;
import com.elitesland.cbpl.unicom.context.Industry;
import com.elitesland.cbpl.unicom.context.ProcContext;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.system.dto.SysTenantDTO;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TenantAdapter
implements UnicomAdapter {
    private static final Logger logger = LoggerFactory.getLogger(TenantAdapter.class);
    private static final String ERR_TENANT_CONTEXT_CONFIG = "\u627e\u4e0d\u5230\u79df\u6237\u7684\u5b9e\u65bd\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";

    public Object filter(List<Object> providers) {
        Optional<Object> customerProvider = providers.stream().filter(this::matchCustomize).findAny();
        if (customerProvider.isPresent()) {
            logger.debug("[CBPL-PHOENIX] context provider: {}", (Object)customerProvider.getClass().getSimpleName());
            return customerProvider.get();
        }
        Optional<Object> industryProvider = providers.stream().filter(this::matchIndustry).findAny();
        if (industryProvider.isPresent()) {
            logger.debug("[CBPL-PHOENIX] context provider: {}", (Object)industryProvider.getClass().getSimpleName());
            return industryProvider.get();
        }
        Object generalProvider = providers.stream().filter(this::matchGeneral).findAny().orElseThrow(() -> {
            throw new BusinessException(ERR_TENANT_CONTEXT_CONFIG);
        });
        logger.debug("[CBPL-PHOENIX] context provider: {}", (Object)generalProvider.getClass().getSimpleName());
        return generalProvider;
    }

    private boolean matchCustomize(Object provider) {
        UnicomTag annotation = provider.getClass().getAnnotation(UnicomTag.class);
        return TenantAdapter.currentCustomize().match(Customize.fromCode(annotation.value()));
    }

    private boolean matchIndustry(Object provider) {
        UnicomTag annotation = provider.getClass().getAnnotation(UnicomTag.class);
        return TenantAdapter.currentIndustry().match(Industry.fromCode(annotation.value()));
    }

    private boolean matchGeneral(Object provider) {
        UnicomTag annotation = provider.getClass().getAnnotation(UnicomTag.class);
        return TenantAdapter.general().match(Industry.fromCode(annotation.value()));
    }

    private static ProcContext general() {
        ProcContext ctx = new ProcContext();
        ctx.setIndustryKey(Industry.GENERAL);
        return ctx;
    }

    private static ProcContext currentIndustry() {
        ProcContext ctx = TenantAdapter.general();
        SysTenantDTO tenant = IamUserUtil.currentTenant();
        if (ObjectUtil.isNotNull((Object)tenant)) {
            ctx.setIndustryKey(Industry.fromCode(tenant.getIndustry()));
        }
        return ctx;
    }

    private static ProcContext currentCustomize() {
        ProcContext ctx = new ProcContext();
        ctx.setCustomizeKey(Customize.STANDARD);
        SysTenantDTO tenant = IamUserUtil.currentTenant();
        if (ObjectUtil.isNotNull((Object)tenant)) {
            ctx.setCustomizeKey(Customize.fromCode(tenant.getCustomer()));
        }
        return ctx;
    }
}

