package com.elitesland.cbpl.kumiho.annotation;

import org.springframework.scheduling.config.ScheduledTaskRegistrar;

import java.lang.annotation.*;

/**
 * @author eric.hao
 * @since 2022/10/10
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface KumihoCron {

    /**
     * A cron-like expression, extending the usual UN*X definition to include triggers
     * on the second, minute, hour, day of month, month, and day of week.
     * <p>For example, {@code "0 * * * * MON-FRI"} means once per minute on weekdays
     * (at the top of the minute - the 0th second).
     * <p>The fields read from left to right are interpreted as follows.
     * <ul>
     * <li>second</li>
     * <li>minute</li>
     * <li>hour</li>
     * <li>day of month</li>
     * <li>month</li>
     * <li>day of week</li>
     * </ul>
     * <p>The special value {@link ScheduledTaskRegistrar#CRON_DISABLED "-"} indicates a disabled cron
     * trigger, primarily meant for externally specified values resolved by a
     * <code>${...}</code> placeholder.
     *
     * @return an expression that can be parsed to a cron schedule
     * @see org.springframework.scheduling.support.CronExpression#parse(String)
     */
    String value() default "";
}
