package com.elitesland.cbpl.kumiho.aop;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.elastic.repository.ElasticRepository;
import com.elitesland.cbpl.kumiho.util.KumihoEsUtil;
import com.elitesland.cbpl.iam.IamUserUtil;
import com.elitesland.cbpl.kumiho.annotation.KumihoCommand;
import com.elitesland.cbpl.kumiho.handler.KumihoDataHandler;
import com.elitesland.cbpl.unicom.util.ApplicationContextGetBeanHelper;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author eric.hao
 * @since 2022/10/10
 */
@Aspect
@Slf4j
@Component
@RequiredArgsConstructor
public class KumihoCommandAop {

    @Autowired
    private ElasticRepository elasticRepository;

    @Pointcut("@annotation(com.elitesland.cbpl.kumiho.annotation.KumihoCommand)")
    public void commandCut() {
    }

    @AfterReturning(value = "commandCut()", returning = "retObj")
    public void after(JoinPoint point, Object retObj) {
        // 读取类实例
        Class<? extends KumihoDataHandler> clazz = ((MethodSignature) point.getSignature()).getMethod().getAnnotation(KumihoCommand.class).value();
        var handler = (KumihoDataHandler) ApplicationContextGetBeanHelper.getBean(clazz.getName());
        if (ObjectUtil.isNull(handler)) {
            throw new RuntimeException("[KUMIHO] " + clazz.getName() + "：未找到类实例");
        }
        // 读到待同步的数据
        List<?> data = handler.queryData(point.getArgs(), retObj);
        String tenantId = IamUserUtil.currentTenantIdStr();
        logger.debug("[KUMIHO] 租户({}), 同步的实体类({}), 待同步数据：{}", tenantId, clazz.getName(), data);
        dataAsync(data);
    }

    private void dataAsync(List<?> data) {
        if (CollUtil.isEmpty(data)) {
            return;
        }
        Class<?> clazz = data.get(0).getClass();
        // 分批次同步到ES
        elasticRepository.batchInsert(data, KumihoEsUtil.indexNameByClz(clazz));
    }
}
