package com.elitesland.cbpl.kumiho.handler;

import java.util.List;

/**
 * @author eric.hao
 * @since 2022/10/10
 */
public interface KumihoDataHandler<T> {

    /**
     * 读模型数据
     *
     * @param args   原方法入参
     * @param result 原方法出参
     * @return 待同步到读模型的数据
     */
    List<T> queryData(Object[] args, Object result);

    /**
     * 单条数据同步 - 新增或修改
     *
     * @param param 查询条件
     * @return 待同步数据
     */
    T restoreDataEvent(String param);

    /**
     * 单条数据同步 - 覆盖更新
     *
     * @param param 查询条件
     * @return 待同步数据
     */
    T restoreDataOverrideEvent(String param);

    /**
     * 批量数据同步 - 新增或修改
     *
     * @param param 查询条件
     * @return 待同步数据
     */
    List<T> restoreDataBatchEvent(String param);

    /**
     * 批量数据同步 - 覆盖更新
     *
     * @param param 查询条件
     * @return 待同步数据
     */
    List<T> restoreDataOverrideBatchEvent(String param);
}
