package com.elitesland.cbpl.kumiho.util;

import com.elitesland.cbpl.iam.IamUserUtil;

import static com.elitesland.cbpl.util.StringTools.humpToUnderline;

/**
 * @author eric.hao
 * @since 2022/10/13
 */
public class KumihoEsUtil {

    private static final String TENANT_SHORT_PREFIX = "_tenant_";

    /**
     * 根据类名，生成索引名称
     *
     * @param clazz 存储对象
     * @return 类名_tenant_id
     */
    public static String indexNameByClz(Class<?> clazz) {
        String tenantId = IamUserUtil.currentTenantIdStr();
        return humpToUnderline(clazz.getSimpleName()) + TENANT_SHORT_PREFIX + tenantId;
    }
}
