package com.elitesland.cbpl.unicom.context;

import lombok.Getter;

/**
 * @author eric.hao
 * @since 2022/03/21
 */
public enum Customize {

    /**
     * 定制开发版本
     */
    STANDARD("通用标准实施"),
    JIUMAOJIU("九毛九"),
    WEIGAO("威高医疗"),
    TONGMING("东明"),
    HEFU("和府捞面"),
    GUOYAO("国药器械"),
    ;

    public String getCode() {
        return name();
    }

    @Getter
    private final String desc;

    Customize(String desc) {
        this.desc = desc;
    }

    public static Customize fromCode(String mode) {
        for (Customize e : Customize.values()) {
            if (e.getCode().equals(mode)) {
                return e;
            }
        }
        return STANDARD;
    }
}
