package com.elitesland.cbpl.kumiho.domain;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.time.Instant;

/**
 * @author eric.hao
 * @since 2022/10/14
 */
@Data
public abstract class KumihoBean {

    @ApiModelProperty(value = "文档主键")
    @Field(name = "@rowKey", type = FieldType.Keyword)
    private String rowKey;

    /**
     * 文档主键
     *
     * @return 主键
     */
    public abstract String getRowKey();

    @ApiModelProperty(value = "记录时间")
    @Field(name = "@timestamp", type = FieldType.Date, format = DateFormat.date_hour_minute_second_millis)
    private Instant timestamp = Instant.now();
}
