package com.elitesland.cbpl.unicom.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author eric.hao
 * @since 2022/06/30
 */
public class ParamAnalyser {

    @SuppressWarnings("unchecked")
    public static Object[] parse(Object provider, Method method, Object[] args) {
        // 接口泛型参数名称
        List<String> genericTypes = Arrays.stream(method.getDeclaringClass().getTypeParameters())
                .map(TypeVariable::getName).collect(Collectors.toList());
        if (CollUtil.isEmpty(genericTypes)) {
            return args;
        }
        // 实现类的参数对象列表
        List<Class<?>> interfaceClass = ParamAnalyser.getInterfaceClass(provider);
        // 场景1
        if (isGenericParameterizedType(method)) {
            // 执行方法的泛型名
            String typeName = method.getGenericParameterTypes()[0].getTypeName();
            int idx = genericTypes.indexOf(typeName);
            args[0] = BeanUtil.toBean(args[0], interfaceClass.get(idx));
        }
        // 场景2
        else if (isListParameterizedType(method)) {
            // 执行方法的泛型名
            ParameterizedType genericParameterType = (ParameterizedType) method.getGenericParameterTypes()[0];
            String typeName = genericParameterType.getActualTypeArguments()[0].getTypeName();
            Class<?> arrClass = interfaceClass.get(genericTypes.indexOf(typeName));
            args[0] = ((ArrayList) args[0]).stream().map(row -> BeanUtil.toBean(row, arrClass)).collect(Collectors.toList());
        }
        return args;
    }

    /**
     * 实现类的参数对象列表
     */
    private static List<Class<?>> getInterfaceClass(Object o) {
        Type[] types = o.getClass().getGenericInterfaces();

        // 解决CGLIB动态代理问题
        if (o.getClass().getName().contains("CGLIB")) {
            types = o.getClass().getSuperclass().getGenericInterfaces();
        }

        ParameterizedType parameterizedType = (ParameterizedType) types[0];
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        List<Class<?>> clzz = new ArrayList<>();

        // 获取泛型接口的泛型参数
        for (Type type : actualTypeArguments) {
            if (!(type instanceof Class)) {
                throw new RuntimeException("Missing type parameter.");
            }
            clzz.add((Class<?>) type);
        }
        return clzz;
    }

    /**
     * 目前仅支持一个泛型参数，待完善
     */
    private static boolean isGenericParameterizedType(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length == 1 && parameterTypes[0].equals(Object.class);
    }

    private static boolean isListParameterizedType(Method method) {
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        if (genericParameterTypes.length != 1) {
            return false;
        }
        if (!(genericParameterTypes[0] instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType genericParameterType = (ParameterizedType) genericParameterTypes[0];
        return !(genericParameterType.getActualTypeArguments()[0] instanceof Class);
    }

    private static Class<?> getClass(Object o) {
        Type[] types = o.getClass().getGenericInterfaces();
        ParameterizedType parameterizedType = (ParameterizedType) types[0];
        return (Class<?>) parameterizedType.getActualTypeArguments()[0];
    }
}
