package com.elitesland.cbpl.unicom.util;

import com.elitesland.cbpl.unicom.config.UnicomProperties;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

import java.net.URL;
import java.util.Collection;

import static org.reflections.scanners.Scanners.*;

/**
 * @author eric.hao
 * @since 2022/06/29
 */
public class ReflectionUtil {

    public static Reflections getReflections(UnicomProperties properties) {
        Collection<URL> urls = ClasspathHelper.forPackage(properties.getBasePackage());
        return new Reflections(new ConfigurationBuilder()
                .setUrls(urls).addScanners(TypesAnnotated, SubTypes, FieldsAnnotated));
    }
}