/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unicom.config;

import com.elitesland.cbpl.unicom.domain.InvokeMode;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConfigurationProperties(prefix="cbpl.unicom")
public class UnicomProperties {
    public static final String UNICOM_PREFIX = "cbpl.unicom";
    private String basePackage;
    private InvokeModeCfg invokeMode;

    public InvokeMode invokeMode(String domain) {
        if (this.invokeMode.getFeign().contains(domain)) {
            return InvokeMode.FEIGN;
        }
        if (this.invokeMode.getDubbo().contains(domain)) {
            return InvokeMode.DUBBO;
        }
        return InvokeMode.JVM;
    }

    public static UnicomProperties from(Environment environment) {
        Binder env = Binder.get((Environment)environment);
        BindResult properties = env.bind(UNICOM_PREFIX, UnicomProperties.class);
        return (UnicomProperties)properties.get();
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public InvokeModeCfg getInvokeMode() {
        return this.invokeMode;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setInvokeMode(InvokeModeCfg invokeMode) {
        this.invokeMode = invokeMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnicomProperties)) {
            return false;
        }
        UnicomProperties other = (UnicomProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$basePackage = this.getBasePackage();
        String other$basePackage = other.getBasePackage();
        if (this$basePackage == null ? other$basePackage != null : !this$basePackage.equals(other$basePackage)) {
            return false;
        }
        InvokeModeCfg this$invokeMode = this.getInvokeMode();
        InvokeModeCfg other$invokeMode = other.getInvokeMode();
        return !(this$invokeMode == null ? other$invokeMode != null : !((Object)this$invokeMode).equals(other$invokeMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnicomProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $basePackage = this.getBasePackage();
        result = result * 59 + ($basePackage == null ? 43 : $basePackage.hashCode());
        InvokeModeCfg $invokeMode = this.getInvokeMode();
        result = result * 59 + ($invokeMode == null ? 43 : ((Object)$invokeMode).hashCode());
        return result;
    }

    public String toString() {
        return "UnicomProperties(basePackage=" + this.getBasePackage() + ", invokeMode=" + this.getInvokeMode() + ")";
    }

    static class InvokeModeCfg {
        private Set<String> jvm;
        private Set<String> dubbo;
        private Set<String> feign;

        public Set<String> getJvm() {
            return this.jvm;
        }

        public Set<String> getDubbo() {
            return this.dubbo;
        }

        public Set<String> getFeign() {
            return this.feign;
        }

        public void setJvm(Set<String> jvm) {
            this.jvm = jvm;
        }

        public void setDubbo(Set<String> dubbo) {
            this.dubbo = dubbo;
        }

        public void setFeign(Set<String> feign) {
            this.feign = feign;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvokeModeCfg)) {
                return false;
            }
            InvokeModeCfg other = (InvokeModeCfg)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<String> this$jvm = this.getJvm();
            Set<String> other$jvm = other.getJvm();
            if (this$jvm == null ? other$jvm != null : !((Object)this$jvm).equals(other$jvm)) {
                return false;
            }
            Set<String> this$dubbo = this.getDubbo();
            Set<String> other$dubbo = other.getDubbo();
            if (this$dubbo == null ? other$dubbo != null : !((Object)this$dubbo).equals(other$dubbo)) {
                return false;
            }
            Set<String> this$feign = this.getFeign();
            Set<String> other$feign = other.getFeign();
            return !(this$feign == null ? other$feign != null : !((Object)this$feign).equals(other$feign));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InvokeModeCfg;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<String> $jvm = this.getJvm();
            result = result * 59 + ($jvm == null ? 43 : ((Object)$jvm).hashCode());
            Set<String> $dubbo = this.getDubbo();
            result = result * 59 + ($dubbo == null ? 43 : ((Object)$dubbo).hashCode());
            Set<String> $feign = this.getFeign();
            result = result * 59 + ($feign == null ? 43 : ((Object)$feign).hashCode());
            return result;
        }

        public String toString() {
            return "UnicomProperties.InvokeModeCfg(jvm=" + this.getJvm() + ", dubbo=" + this.getDubbo() + ", feign=" + this.getFeign() + ")";
        }
    }
}

