/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unicom.register;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.annotation.UnicomReference;
import com.elitesland.cbpl.unicom.config.UnicomProperties;
import com.elitesland.cbpl.unicom.domain.InvokeMode;
import com.elitesland.cbpl.unicom.proxy.UnicomInterfaceProxyFactoryBean;
import com.elitesland.cbpl.unicom.util.ReflectionUtil;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class ProxyBeanDefinitionRegister
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(ProxyBeanDefinitionRegister.class);
    private UnicomProperties properties;

    public void postProcessBeanDefinitionRegistry(@Nonnull BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        Reflections reflections = ReflectionUtil.getReflections(this.properties);
        Set typesAnnotatedWith = reflections.getTypesAnnotatedWith(Unicom.class);
        Set fieldsAnnotatedWith = reflections.getFieldsAnnotatedWith(UnicomReference.class);
        for (Class superClass : typesAnnotatedWith) {
            if (!superClass.isInterface()) continue;
            Unicom anno = superClass.getAnnotation(Unicom.class);
            InvokeMode mode = this.properties.invokeMode(anno.domain());
            switch (mode) {
                case JVM: {
                    this.jvmRegister(beanDefinitionRegistry, superClass);
                    break;
                }
                case DUBBO: {
                    Set<String> versions = fieldsAnnotatedWith.stream().filter(row -> row.getType().equals(superClass)).map(row -> row.getAnnotation(UnicomReference.class).dv()).collect(Collectors.toSet());
                    versions.forEach(version -> this.dubboRegister(beanDefinitionRegistry, superClass, (String)version));
                    break;
                }
            }
        }
    }

    private void jvmRegister(BeanDefinitionRegistry beanDefinitionRegistry, Class<?> superClass) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(UnicomInterfaceProxyFactoryBean.class);
        beanDefinition.getPropertyValues().addPropertyValue("unicomInterface", superClass);
        beanDefinition.setPrimary(true);
        beanDefinition.setAutowireMode(2);
        logger.debug("[UNICOM] jvm register className({}), beanDefinition({}).", (Object)superClass.getSimpleName(), (Object)beanDefinition);
        beanDefinitionRegistry.registerBeanDefinition(superClass.getSimpleName(), (BeanDefinition)beanDefinition);
    }

    private void dubboRegister(BeanDefinitionRegistry beanDefinitionRegistry, Class<?> superClass, String version) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(ReferenceBean.class);
        beanDefinition.setAttribute("interfaceClass", superClass);
        beanDefinition.setAttribute("interfaceName", (Object)superClass.getName());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("id", StrUtil.lowerFirst((CharSequence)superClass.getSimpleName()));
        props.put("interface", superClass.getName());
        props.put("version", version);
        beanDefinition.setAttribute("referenceProps", props);
        beanDefinition.setPrimary(true);
        beanDefinition.setAutowireMode(2);
        logger.debug("[UNICOM] dubbo register className({}), beanDefinition({}).", (Object)superClass.getSimpleName(), (Object)beanDefinition);
        beanDefinitionRegistry.registerBeanDefinition(superClass.getSimpleName(), (BeanDefinition)beanDefinition);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
    }

    public void setEnvironment(Environment environment) {
        this.properties = UnicomProperties.from(environment);
    }
}

