/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unicom.proxy;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.unicom.adapter.UnicomAdapter;
import com.elitesland.cbpl.unicom.util.ApplicationContextGetBeanHelper;
import com.elitesland.cbpl.unicom.util.ParamAnalyser;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

public class UnicomInterfaceProxy
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(UnicomInterfaceProxy.class);
    private final Reflections reflections;

    public UnicomInterfaceProxy(Reflections reflections) {
        this.reflections = reflections;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        List<Object> providers = this.reflections.getSubTypesOf(method.getDeclaringClass()).stream().map(Class::getName).map(ApplicationContextGetBeanHelper::getBean).collect(Collectors.toList());
        if (CollUtil.isEmpty(providers)) {
            throw new RuntimeException("[UNICOM] " + method.getDeclaringClass() + "\uff1a\u672a\u627e\u5230\u4efb\u4f55\u5b9e\u73b0\u7c7b");
        }
        Object provider = this.resolveAdapter(providers);
        return methodProxy.invoke(provider, ParamAnalyser.parse(provider, method, args));
    }

    private Object resolveAdapter(List<Object> providers) {
        UnicomAdapter adapter = this.loadAdapter();
        if (ObjectUtil.isNull((Object)adapter)) {
            for (Object row : providers) {
                logger.debug("[UNICOM] load impl className({})", (Object)row.getClass().getSimpleName());
            }
            Object provider = providers.get(0);
            logger.debug("[UNICOM] execute impl className({})", (Object)providers.get(0).getClass().getSimpleName());
            return provider;
        }
        return adapter.filter(providers);
    }

    private UnicomAdapter loadAdapter() {
        List adapters = this.reflections.getSubTypesOf(UnicomAdapter.class).stream().map(Class::getName).map(row -> (UnicomAdapter)ApplicationContextGetBeanHelper.getBean(row)).collect(Collectors.toList());
        if (CollUtil.isEmpty(adapters)) {
            return null;
        }
        for (UnicomAdapter adapter : adapters) {
            logger.debug("[UNICOM] load adapter className({})", (Object)adapter.getClass().getSimpleName());
        }
        UnicomAdapter adapter = (UnicomAdapter)adapters.get(0);
        logger.debug("[UNICOM] execute adapter className({})", (Object)adapter.getClass().getSimpleName());
        return adapter;
    }
}

