package com.elitesland.cbpl.unicom.register;

import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.config.UnicomProperties;
import com.elitesland.cbpl.unicom.domain.InvokeMode;
import com.elitesland.cbpl.unicom.proxy.UnicomInterfaceProxyFactoryBean;
import com.elitesland.cbpl.unicom.util.ReflectionUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.spring.Constants;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.apache.dubbo.config.spring.reference.ReferenceAttributes;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * 注册代理类
 *
 * @author eric.hao
 * @since 2022/06/28
 */
@Slf4j
@Configuration
public class ProxyBeanDefinitionRegister implements BeanDefinitionRegistryPostProcessor {

    @Autowired
    private UnicomProperties properties;

    @Override
    public void postProcessBeanDefinitionRegistry(@Nonnull BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        Set<Class<?>> typesAnnotatedWith = ReflectionUtil.getUnicomInterface();
        for (Class<?> superClass : typesAnnotatedWith) {
//            Unicom anno = superClass.getAnnotation(Unicom.class);
//            InvokeMode mode = properties.invokeMode(anno.domain());
//            switch (mode) {
//                case JVM:
//                    x1(beanDefinitionRegistry, superClass);
//                case DUBBO:
//                    x2(beanDefinitionRegistry, superClass);
//                case FEIGN:
//            }
            x1(beanDefinitionRegistry, superClass);
        }
    }

    private void x1(BeanDefinitionRegistry beanDefinitionRegistry, Class<?> superClass) {
        if (!superClass.isInterface()) {
            return;
        }
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        // 指定 Class 类型
        beanDefinition.setBeanClass(UnicomInterfaceProxyFactoryBean.class);
        // 属性集合
        beanDefinition.getPropertyValues().addPropertyValue("unicomInterface", superClass);
        // 是否是首选的 @Primary
        beanDefinition.setPrimary(true);
        // 装配模式
        beanDefinition.setAutowireMode(RootBeanDefinition.AUTOWIRE_BY_TYPE);
        logger.debug("[UNICOM] register className({}), beanDefinition({}).", superClass.getSimpleName(), beanDefinition);
        beanDefinitionRegistry.registerBeanDefinition(superClass.getSimpleName(), beanDefinition);
    }

    private void x2(BeanDefinitionRegistry beanDefinitionRegistry, Class<?> superClass) {
        ReferenceBean<?> itmItemRpcService = builder(superClass);
        ReferenceConfig<?> config = builder2(superClass);
        config.setVersion("");
        itmItemRpcService.setKeyAndReferenceConfig("", config);
        Class<?> superClass2 = itmItemRpcService.getClass();
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        // 指定 Class 类型
        beanDefinition.setBeanClass(ReferenceBean.class);
        beanDefinition.setAttribute(ReferenceAttributes.INTERFACE_CLASS, superClass);
        beanDefinition.setAttribute(ReferenceAttributes.INTERFACE_NAME, superClass.getName());
        Map<String, Object> props = new HashMap<>();
        props.put("id", "itmItemRpcService");
        props.put("interface", superClass.getName());
        beanDefinition.setAttribute(Constants.REFERENCE_PROPS, props);
        // 是否是首选的 @Primary
        beanDefinition.setPrimary(true);
        // 装配模式
        beanDefinition.setAutowireMode(RootBeanDefinition.AUTOWIRE_BY_TYPE);
        logger.info("[UNICOM] register className({}), beanDefinition({}).", superClass2.getSimpleName(), beanDefinition);
        beanDefinitionRegistry.registerBeanDefinition(superClass2.getSimpleName(), beanDefinition);
    }

    private <T> ReferenceBean<?> builder(Class<T> clazz) {
        return new ReferenceBean<T>();
    }

    private <T> ReferenceConfig<T> builder2(Class<T> clazz) {
        return new ReferenceConfig<T>();
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
    }
}