package com.elitesland.cbpl.unicom.config;

import com.elitesland.cbpl.unicom.proxy.UnicomInterfaceProxy;
import lombok.extern.slf4j.Slf4j;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.net.URL;
import java.util.Collection;

import static org.reflections.scanners.Scanners.SubTypes;
import static org.reflections.scanners.Scanners.TypesAnnotated;

/**
 * @author eric.hao
 * @since 2022/06/29
 */
@Slf4j
@Configuration
public class UnicomConfig {

//    @Autowired
//    private UnicomProperties properties;

    /**
     * 反射类扫描注册
     */
    @Bean
    @ConditionalOnMissingBean
    public Reflections reflections() {
        logger.info("[UNICOM] load reflections.");
        Collection<URL> urls = ClasspathHelper.forPackage("com.elitesland");
        return new Reflections(new ConfigurationBuilder()
                .setUrls(urls).addScanners(TypesAnnotated, SubTypes));
    }

    /**
     * 接口拦截代理
     */
    @Bean
    public UnicomInterfaceProxy unicomInterfaceProxy(Reflections reflections) {
        logger.info("[UNICOM] load unicom interface proxy.");
        return new UnicomInterfaceProxy(reflections);
    }
}
