package com.elitesland.cbpl.unicom.util;

import com.elitesland.cbpl.unicom.annotation.Unicom;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

import java.net.URL;
import java.util.Collection;
import java.util.Set;

import static org.reflections.scanners.Scanners.*;

/**
 * @author eric.hao
 * @since 2022/06/29
 */
public class ReflectionUtil {

    public static Set<Class<?>> getUnicomInterface() {
        Reflections reflections = getReflections();
        return reflections.getTypesAnnotatedWith(Unicom.class);
    }

    public static Reflections getReflections() {
        Collection<URL> urls = ClasspathHelper.forPackage("com.elitesland");
        return new Reflections(new ConfigurationBuilder()
                .setUrls(urls).addScanners(TypesAnnotated, SubTypes, FieldsAnnotated));
    }
}