/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unicom.config;

import com.elitesland.cbpl.unicom.config.InvokeModeCfg;
import com.elitesland.cbpl.unicom.domain.InvokeMode;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="cbpl.unicom")
public class UnicomProperties {
    public static final String UNICOM_PREFIX = "cbpl.unicom";
    private String basePackage;
    private InvokeModeCfg invokeMode;

    public InvokeMode invokeMode(String domain) {
        if (this.invokeMode.getFeign().contains(domain)) {
            return InvokeMode.FEIGN;
        }
        if (this.invokeMode.getDubbo().contains(domain)) {
            return InvokeMode.DUBBO;
        }
        return InvokeMode.JVM;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public InvokeModeCfg getInvokeMode() {
        return this.invokeMode;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setInvokeMode(InvokeModeCfg invokeMode) {
        this.invokeMode = invokeMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnicomProperties)) {
            return false;
        }
        UnicomProperties other = (UnicomProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$basePackage = this.getBasePackage();
        String other$basePackage = other.getBasePackage();
        if (this$basePackage == null ? other$basePackage != null : !this$basePackage.equals(other$basePackage)) {
            return false;
        }
        InvokeModeCfg this$invokeMode = this.getInvokeMode();
        InvokeModeCfg other$invokeMode = other.getInvokeMode();
        return !(this$invokeMode == null ? other$invokeMode != null : !((Object)this$invokeMode).equals(other$invokeMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnicomProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $basePackage = this.getBasePackage();
        result = result * 59 + ($basePackage == null ? 43 : $basePackage.hashCode());
        InvokeModeCfg $invokeMode = this.getInvokeMode();
        result = result * 59 + ($invokeMode == null ? 43 : ((Object)$invokeMode).hashCode());
        return result;
    }

    public String toString() {
        return "UnicomProperties(basePackage=" + this.getBasePackage() + ", invokeMode=" + this.getInvokeMode() + ")";
    }
}

