package com.elitesland.cbpl.unicom.adapter;

import com.elitesland.cbpl.unicom.annotation.Adapter;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/04/25
 */
@Slf4j
@Adapter
public class DefaultUnicomAdapter implements UnicomAdapter {

    @Override
    public Object filter(List<Object> providers) {
        for (Object row : providers) {
            logger.debug("[UNICOM] load impl className({})", row.getClass().getSimpleName());
        }
        Object provider = providers.get(0);
        logger.debug("[UNICOM] execute impl className({})", providers.get(0).getClass().getSimpleName());
        return provider;
    }
}
