/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unicom.register;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.unicom.adapter.UnicomAdapter;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.annotation.UnicomReference;
import com.elitesland.cbpl.unicom.config.UnicomProperties;
import com.elitesland.cbpl.unicom.domain.InvokeMode;
import com.elitesland.cbpl.unicom.proxy.UnicomAdapterProxyFactoryBean;
import com.elitesland.cbpl.unicom.proxy.UnicomInterfaceProxyFactoryBean;
import com.elitesland.cbpl.unicom.util.ReflectionUtil;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.FeignClientFactoryBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class ProxyBeanDefinitionRegister
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(ProxyBeanDefinitionRegister.class);
    private UnicomProperties properties;

    public void postProcessBeanDefinitionRegistry(@Nonnull BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        Reflections reflections = ReflectionUtil.getReflections(this.properties);
        this.defaultRegister(beanDefinitionRegistry, reflections);
        Set typesAnnotatedWith = reflections.getTypesAnnotatedWith(Unicom.class);
        Set fieldsAnnotatedWith = reflections.getFieldsAnnotatedWith(UnicomReference.class);
        for (Class superClass : typesAnnotatedWith) {
            if (!superClass.isInterface()) continue;
            Unicom anno = superClass.getAnnotation(Unicom.class);
            if (ObjectUtil.isNull((Object)anno)) {
                logger.debug("[UNICOM] register className({}) not contain @Unicom annotation.", (Object)superClass.getName());
                continue;
            }
            InvokeMode mode = this.properties.invokeMode(anno.domain());
            switch (mode) {
                case JVM: {
                    this.jvmRegister(beanDefinitionRegistry, superClass);
                    break;
                }
                case DUBBO: {
                    Set<String> versions = fieldsAnnotatedWith.stream().filter(row -> row.getType().equals(superClass)).map(row -> row.getAnnotation(UnicomReference.class).dv()).collect(Collectors.toSet());
                    versions.forEach(version -> this.dubboRegister(beanDefinitionRegistry, superClass, (String)version));
                    break;
                }
                case FEIGN: {
                    this.feignRegister(beanDefinitionRegistry, superClass);
                }
            }
        }
    }

    private void defaultRegister(BeanDefinitionRegistry beanDefinitionRegistry, Reflections reflections) {
        Class<UnicomAdapter> superClass = UnicomAdapter.class;
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(UnicomAdapterProxyFactoryBean.class);
        beanDefinition.getPropertyValues().addPropertyValue("unicomAdapter", superClass);
        beanDefinition.setPrimary(true);
        beanDefinition.setAutowireMode(2);
        logger.debug("[UNICOM] default register className({}), beanDefinition({}).", (Object)superClass.getSimpleName(), (Object)beanDefinition);
        beanDefinitionRegistry.registerBeanDefinition(superClass.getSimpleName(), (BeanDefinition)beanDefinition);
    }

    private void jvmRegister(BeanDefinitionRegistry beanDefinitionRegistry, Class<?> superClass) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(UnicomInterfaceProxyFactoryBean.class);
        beanDefinition.getPropertyValues().addPropertyValue("unicomInterface", superClass);
        beanDefinition.setPrimary(true);
        beanDefinition.setAutowireMode(2);
        logger.debug("[UNICOM] jvm register className({}), beanDefinition({}).", (Object)superClass.getSimpleName(), (Object)beanDefinition);
        beanDefinitionRegistry.registerBeanDefinition(superClass.getSimpleName(), (BeanDefinition)beanDefinition);
    }

    private void dubboRegister(BeanDefinitionRegistry beanDefinitionRegistry, Class<?> superClass, String version) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(ReferenceBean.class);
        beanDefinition.setAttribute("interfaceClass", superClass);
        beanDefinition.setAttribute("interfaceName", (Object)superClass.getName());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("id", StrUtil.lowerFirst((CharSequence)superClass.getSimpleName()));
        props.put("interface", superClass.getName());
        props.put("version", version);
        beanDefinition.setAttribute("referenceProps", props);
        beanDefinition.setPrimary(true);
        beanDefinition.setAutowireMode(2);
        logger.debug("[UNICOM] dubbo register className({}), beanDefinition({}).", (Object)superClass.getSimpleName(), (Object)beanDefinition);
        beanDefinitionRegistry.registerBeanDefinition(superClass.getSimpleName(), (BeanDefinition)beanDefinition);
    }

    private void feignRegister(BeanDefinitionRegistry beanDefinitionRegistry, Class<?> superClass) {
        FeignClient feignClient = superClass.getAnnotation(FeignClient.class);
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(FeignClientFactoryBean.class);
        beanDefinition.getPropertyValues().add("type", superClass);
        beanDefinition.getPropertyValues().add("name", (Object)feignClient.name());
        beanDefinition.getPropertyValues().add("contextId", (Object)StrUtil.lowerFirst((CharSequence)superClass.getSimpleName()));
        beanDefinition.getPropertyValues().add("url", (Object)feignClient.url());
        beanDefinition.getPropertyValues().add("path", (Object)feignClient.path());
        beanDefinition.getPropertyValues().add("decode404", (Object)false);
        beanDefinition.setPrimary(true);
        beanDefinition.setAutowireMode(2);
        logger.debug("[UNICOM] openfeign register className({}), beanDefinition({}).", (Object)superClass.getSimpleName(), (Object)beanDefinition);
        beanDefinitionRegistry.registerBeanDefinition(superClass.getSimpleName(), (BeanDefinition)beanDefinition);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
    }

    public void setEnvironment(Environment environment) {
        this.properties = UnicomProperties.from(environment);
    }
}

