/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unicom.config;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.cbpl.unicom.config.UnicomProperties;
import com.elitesland.cbpl.unicom.proxy.UnicomAdapterProxy;
import com.elitesland.cbpl.unicom.proxy.UnicomInterfaceProxy;
import java.util.ArrayList;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class UnicomConfig
implements EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(UnicomConfig.class);
    private UnicomProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public Reflections reflections() {
        logger.info("[UNICOM] load reflections.");
        ArrayList urls = new ArrayList();
        if (CollUtil.isNotEmpty(this.properties.getBasePackage())) {
            for (String basePackage : this.properties.getBasePackage()) {
                urls.addAll(ClasspathHelper.forPackage((String)basePackage, (ClassLoader[])new ClassLoader[0]));
            }
        }
        return new Reflections((org.reflections.Configuration)new ConfigurationBuilder().setUrls(urls).addScanners(new Scanner[]{Scanners.TypesAnnotated, Scanners.SubTypes}));
    }

    @Bean
    public UnicomInterfaceProxy unicomInterfaceProxy(Reflections reflections) {
        logger.info("[UNICOM] load unicom interface proxy.");
        return new UnicomInterfaceProxy(reflections, this.properties);
    }

    @Bean
    public UnicomAdapterProxy unicomAdapterProxy(Reflections reflections) {
        logger.info("[UNICOM] load unicom adapter proxy.");
        return new UnicomAdapterProxy(reflections, this.properties);
    }

    public void setEnvironment(Environment environment) {
        this.properties = UnicomProperties.from(environment);
    }
}

