package com.elitesland.cbpl.unicom.annotation;

import com.elitesland.cbpl.unicom.adapter.DefaultUnicomAdapter;
import com.elitesland.cbpl.unicom.adapter.UnicomAdapter;

import java.lang.annotation.*;

/**
 * @author eric.hao
 * @since 2022/06/28
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Unicom {

    /**
     * DDD的领域模型<br/>
     * 一般根据系统配置{@link com.elitesland.cbpl.unicom.domain.InvokeMode}，决定该域的调用方式
     */
    String domain() default "";

    /**
     * 规则适配器
     */
    Class<? extends UnicomAdapter> adapter() default DefaultUnicomAdapter.class;
}
