package com.elitesland.cbpl.unicom.annotation;

import com.elitesland.cbpl.unicom.adapter.DefaultUnicomAdapter;
import com.elitesland.cbpl.unicom.adapter.UnicomAdapter;

import java.lang.annotation.*;

/**
 * @author eric.hao
 * @since 2022/06/28
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Unicom {

    /**
     * DDD的领域模型<br/>
     * 1. 一般根据系统配置{@link com.elitesland.cbpl.unicom.domain.InvokeMode}，决定该域的调用方式
     * <br/>
     * 2. 常规赋值可以使用{@link com.elitesland.cbpl.unicom.domain.InvokeDomain}
     * 但也允许自定义名称，注意需与invokeMode配置中的服务名称保持一致
     * <br/>
     * 3. 当配置选用`InvokeMode.FEIGN`时，该属性功能等同于`@FeignClient(name='domain')`
     */
    String domain() default "";

    /**
     * 规则适配器
     */
    Class<? extends UnicomAdapter> adapter() default DefaultUnicomAdapter.class;

    /**
     * 搭配`InvokeMode.FEIGN`时使用
     *
     * @return an absolute URL or resolvable hostname (the protocol is optional).
     */
    String url() default "";

    /**
     * 搭配`InvokeMode.FEIGN`时使用
     *
     * @return path prefix to be used by all method-level mappings.
     */
    String path() default "";
}
