/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unicom.register;

import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.proxy.UnicomInterfaceProxyFactoryBean;
import com.elitesland.cbpl.unicom.util.ReflectionUtil;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ProxyBeanDefinitionRegister
implements BeanDefinitionRegistryPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ProxyBeanDefinitionRegister.class);

    public void postProcessBeanDefinitionRegistry(@Nonnull BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        Reflections reflections = ReflectionUtil.getReflections();
        Set typesAnnotatedWith = reflections.getTypesAnnotatedWith(Unicom.class);
        for (Class superClass : typesAnnotatedWith) {
            if (!superClass.isInterface()) continue;
            RootBeanDefinition beanDefinition = new RootBeanDefinition();
            beanDefinition.setBeanClass(UnicomInterfaceProxyFactoryBean.class);
            beanDefinition.getPropertyValues().addPropertyValue("unicomInterface", (Object)superClass);
            beanDefinition.setPrimary(true);
            beanDefinition.setAutowireMode(2);
            logger.debug("[UNICOM] register className({}), beanDefinition({}).", (Object)superClass.getSimpleName(), (Object)beanDefinition);
            beanDefinitionRegistry.registerBeanDefinition(superClass.getSimpleName(), (BeanDefinition)beanDefinition);
        }
    }

    private <T> ReferenceBean<T> builder(Class<T> clazz) {
        ReferenceBean referenceBean = new ReferenceBean();
        return referenceBean;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
    }
}

