/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unicom.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ParamAnalyser {
    public static Object[] parse(Object provider, Method method, Object[] args) {
        List genericTypes = Arrays.stream(method.getDeclaringClass().getTypeParameters()).map(TypeVariable::getName).collect(Collectors.toList());
        if (CollUtil.isEmpty(genericTypes)) {
            return args;
        }
        List<Class<?>> interfaceClass = ParamAnalyser.getInterfaceClass(provider);
        if (ParamAnalyser.isGenericParameterizedType(method)) {
            String typeName = method.getGenericParameterTypes()[0].getTypeName();
            int idx = genericTypes.indexOf(typeName);
            args[0] = BeanUtil.toBean((Object)args[0], interfaceClass.get(idx));
        } else if (ParamAnalyser.isListParameterizedType(method)) {
            ParameterizedType genericParameterType = (ParameterizedType)method.getGenericParameterTypes()[0];
            String typeName = genericParameterType.getActualTypeArguments()[0].getTypeName();
            Class<?> arrClass = interfaceClass.get(genericTypes.indexOf(typeName));
            args[0] = ((ArrayList)args[0]).stream().map(row -> BeanUtil.toBean((Object)row, (Class)arrClass)).collect(Collectors.toList());
        }
        return args;
    }

    private static List<Class<?>> getInterfaceClass(Object o) {
        Type[] types = o.getClass().getGenericInterfaces();
        if (o.getClass().getName().contains("CGLIB")) {
            types = o.getClass().getSuperclass().getGenericInterfaces();
        }
        ParameterizedType parameterizedType = (ParameterizedType)types[0];
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        ArrayList clzz = new ArrayList();
        for (Type type : actualTypeArguments) {
            if (!(type instanceof Class)) {
                throw new RuntimeException("Missing type parameter.");
            }
            clzz.add((Class)type);
        }
        return clzz;
    }

    private static boolean isGenericParameterizedType(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length == 1 && parameterTypes[0].equals(Object.class);
    }

    private static boolean isListParameterizedType(Method method) {
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        if (genericParameterTypes.length != 1) {
            return false;
        }
        if (!(genericParameterTypes[0] instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType genericParameterType = (ParameterizedType)genericParameterTypes[0];
        return !(genericParameterType.getActualTypeArguments()[0] instanceof Class);
    }

    private static Class<?> getClass(Object o) {
        Type[] types = o.getClass().getGenericInterfaces();
        ParameterizedType parameterizedType = (ParameterizedType)types[0];
        return (Class)parameterizedType.getActualTypeArguments()[0];
    }
}

