package com.elitesland.cbpl.unicom.proxy;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.unicom.adapter.DefaultUnicomAdapter;
import com.elitesland.cbpl.unicom.config.UnicomProperties;
import com.elitesland.cbpl.unicom.util.ApplicationContextGetBeanHelper;
import lombok.extern.slf4j.Slf4j;
import org.reflections.Reflections;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

import java.lang.reflect.Method;

/**
 * @author eric.hao
 * @since 2023/04/25
 */
@Slf4j
public class UnicomAdapterProxy implements MethodInterceptor {

    private final Reflections reflections;
    private final UnicomProperties properties;

    public UnicomAdapterProxy(Reflections reflections, UnicomProperties properties) {
        this.reflections = reflections;
        this.properties = properties;
    }

    /**
     * 委托方法被调用时转发
     *
     * @param obj         代理子类实例
     * @param method      委托类方法反射
     * @param args        方法参数对象
     * @param methodProxy 用于调用原方法
     */
    @Override
    public Object intercept(Object obj, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        Object provider = ApplicationContextGetBeanHelper.getBean(method.getName());
        // 获取系统配置的默认策略：如果有则执行，如果没有则继续
        if (provider instanceof DefaultUnicomAdapter && StrUtil.isNotEmpty(properties.getDefaultAdapter())) {
            String defaultAdapter = properties.getDefaultAdapter();
            provider = ApplicationContextGetBeanHelper.getBean(defaultAdapter);
        }
        return methodProxy.invoke(provider, args);
    }
}
