package com.elitesland.cbpl.unicom.util;

import cn.hutool.core.util.ObjectUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import javax.annotation.Nonnull;

/**
 * 获取上下文的类实例
 *
 * @author eric.hao
 * @since 2022/06/29
 */
@Component
public class ApplicationContextGetBeanHelper implements ApplicationContextAware {

    private static ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        ApplicationContextGetBeanHelper.applicationContext = applicationContext;
    }

    public static Object getBean(String className) throws BeansException, IllegalArgumentException {
        if (StringUtils.isBlank(className)) {
            throw new IllegalArgumentException("类实例不存在");
        }
        String beanName = StringUtils.uncapitalize(className);
        return ObjectUtil.isNotNull(applicationContext) ? applicationContext.getBean(beanName) : null;
    }
}
