/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unicom.proxy;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.unicom.adapter.DefaultUnicomAdapter;
import com.elitesland.cbpl.unicom.adapter.UnicomAdapter;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.config.UnicomProperties;
import com.elitesland.cbpl.unicom.util.ApplicationContextGetBeanHelper;
import com.elitesland.cbpl.unicom.util.ParamAnalyser;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

public class UnicomInterfaceProxy
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(UnicomInterfaceProxy.class);
    private final Reflections reflections;
    private final UnicomProperties properties;

    public UnicomInterfaceProxy(Reflections reflections, UnicomProperties properties) {
        this.reflections = reflections;
        this.properties = properties;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        Class<?> superClass = method.getDeclaringClass();
        List<Object> providers = this.reflections.getSubTypesOf(superClass).stream().map(Class::getName).map(ApplicationContextGetBeanHelper::getBean).collect(Collectors.toList());
        if (CollUtil.isEmpty(providers)) {
            throw new RuntimeException("[UNICOM] " + superClass + "\uff1a\u672a\u627e\u5230\u4efb\u4f55\u5b9e\u73b0\u7c7b");
        }
        Object provider = this.loadAdapter(superClass).filter(providers);
        return methodProxy.invoke(provider, ParamAnalyser.parse(provider, method, args));
    }

    private UnicomAdapter loadAdapter(Class<?> superClass) {
        Unicom anno = superClass.getAnnotation(Unicom.class);
        Class<? extends UnicomAdapter> adapterClass = anno.adapter();
        if (adapterClass.equals(DefaultUnicomAdapter.class) && StrUtil.isNotEmpty((CharSequence)this.properties.getDefaultAdapter())) {
            String defaultAdapter = this.properties.getDefaultAdapter();
            return (UnicomAdapter)ApplicationContextGetBeanHelper.getBean(defaultAdapter);
        }
        return (UnicomAdapter)ApplicationContextGetBeanHelper.getBean(adapterClass.getName());
    }
}

