package com.elitesland.cbpl.unicom.config;

import com.elitesland.cbpl.unicom.domain.InvokeMode;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @author eric.hao
 * @since 2022/09/14
 */
@Data
@Configuration
@ConfigurationProperties(prefix = "cbpl.unicom")
public class UnicomProperties {

    /**
     * 扫描路径
     */
    private String basePackage = "com.elitesland";

    /**
     * 调用方式
     */
    private InvokeModeCfg invokeMode;

    public InvokeMode invokeMode(String domain) {
        // 匹配feign调用方式的域
        if (invokeMode.getFeign().contains(domain)) {
            return InvokeMode.FEIGN;
        }
        // 匹配dubbo调用方式的域
        if (invokeMode.getDubbo().contains(domain)) {
            return InvokeMode.DUBBO;
        }
        // 默认均使用本地调用的方式
        return InvokeMode.JVM;
    }

    @Data
    static class InvokeModeCfg {
        private Set<String> jvm;
        private Set<String> dubbo;
        private Set<String> feign;
    }
}
