/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.unicom.register;

import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.config.UnicomProperties;
import com.elitesland.cbpl.unicom.domain.InvokeMode;
import com.elitesland.cbpl.unicom.proxy.UnicomInterfaceProxyFactoryBean;
import com.elitesland.cbpl.unicom.util.ReflectionUtil;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ProxyBeanDefinitionRegister
implements BeanDefinitionRegistryPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ProxyBeanDefinitionRegister.class);
    private final UnicomProperties properties;

    public void postProcessBeanDefinitionRegistry(@Nonnull BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        Set<Class<?>> typesAnnotatedWith = ReflectionUtil.getUnicomInterface();
        for (Class<?> superClass : typesAnnotatedWith) {
            Unicom anno = superClass.getAnnotation(Unicom.class);
            InvokeMode mode = this.properties.invokeMode(anno.domain());
            switch (mode) {
                case JVM: {
                    this.x1(beanDefinitionRegistry, superClass);
                }
                case DUBBO: {
                    this.x2(beanDefinitionRegistry, superClass);
                }
            }
        }
    }

    private void x1(BeanDefinitionRegistry beanDefinitionRegistry, Class<?> superClass) {
        if (!superClass.isInterface()) {
            return;
        }
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(UnicomInterfaceProxyFactoryBean.class);
        beanDefinition.getPropertyValues().addPropertyValue("unicomInterface", superClass);
        beanDefinition.setPrimary(true);
        beanDefinition.setAutowireMode(2);
        logger.debug("[UNICOM] register className({}), beanDefinition({}).", (Object)superClass.getSimpleName(), (Object)beanDefinition);
        beanDefinitionRegistry.registerBeanDefinition(superClass.getSimpleName(), (BeanDefinition)beanDefinition);
    }

    private void x2(BeanDefinitionRegistry beanDefinitionRegistry, Class<?> superClass) {
        ReferenceBean<?> itmItemRpcService = this.builder(superClass);
        ReferenceConfig<?> config = this.builder2(superClass);
        config.setVersion("");
        itmItemRpcService.setKeyAndReferenceConfig("", config);
        Class<?> superClass2 = itmItemRpcService.getClass();
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(ReferenceBean.class);
        beanDefinition.setAttribute("interfaceClass", superClass);
        beanDefinition.setAttribute("interfaceName", (Object)superClass.getName());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("id", "itmItemRpcService");
        props.put("interface", superClass.getName());
        beanDefinition.setAttribute("referenceProps", props);
        beanDefinition.setPrimary(true);
        beanDefinition.setAutowireMode(2);
        logger.info("[UNICOM] register className({}), beanDefinition({}).", (Object)superClass2.getSimpleName(), (Object)beanDefinition);
        beanDefinitionRegistry.registerBeanDefinition(superClass2.getSimpleName(), (BeanDefinition)beanDefinition);
    }

    private <T> ReferenceBean<?> builder(Class<T> clazz) {
        return new ReferenceBean();
    }

    private <T> ReferenceConfig<T> builder2(Class<T> clazz) {
        return new ReferenceConfig();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
    }

    public ProxyBeanDefinitionRegister(UnicomProperties properties) {
        this.properties = properties;
    }
}

