package com.elitesland.cbpl.tool.core.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;

import java.util.Arrays;

/**
 * 字符串相关工具类
 *
 * @author eric.hao
 * @since 2023/06/11
 */
public class StringUtils extends StrUtil {

    /**
     * 字符串添加双引号
     */
    public static String brackets(String obj) {
        return "\"" + trimToEmpty(obj) + "\"";
    }

    /**
     * String/Object[] => String[]
     */
    public static String[] toArray(Object paramStr) {
        if (BeanUtil.isEmpty(paramStr)) {
            return new String[]{};
        }
        return paramStr instanceof String ? new String[]{(String) paramStr} : resolveArr((Object[]) paramStr);
    }

    /**
     * Object[] => String[]
     */
    private static String[] resolveArr(Object[] paramArr) {
        return Arrays.copyOf(paramArr, paramArr.length, String[].class);
    }
}