/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.websocket.notifier;

import cn.hutool.core.net.url.UrlQuery;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.http.HttpServletUtil;
import com.elitesland.cbpl.tool.websocket.domain.NotifierPayload;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;
import org.springframework.web.socket.sockjs.SockJsTransportFailureException;

public class WebSocketNotifier
extends TextWebSocketHandler {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketNotifier.class);
    private static final String URI_PARAM_USER_ID = "userId";
    private final Map<String, WebSocketSession> sessions = new ConcurrentHashMap<String, WebSocketSession>();
    private final Map<String, String> userSessionIds = new ConcurrentHashMap<String, String>();

    public <T extends NotifierPayload> void notify(T payload) {
        TextMessage message = new TextMessage((CharSequence)BeanUtils.toJsonOrThrow(payload));
        Set<String> recipients = payload.getTos();
        ArrayList recipientsPushed = new ArrayList();
        this.userSessionIds.forEach((uid, sids) -> {
            if (recipients.contains(uid)) {
                for (String sid : sids.split(",")) {
                    if (!ObjectUtil.isNotNull((Object)this.sessions.get(sid)) || !this.sessions.get(sid).isOpen()) continue;
                    try {
                        this.pushToClient(this.sessions.get(sid), message);
                    }
                    catch (SockJsTransportFailureException e) {
                        logger.error("[PHOENIX-WS] {}-pushToClient failed.", (Object)sid);
                    }
                }
                recipientsPushed.add(uid);
            }
        });
        logger.debug("[PHOENIX-WS] recipients has been pushed: {}", recipientsPushed);
    }

    private void pushToClient(WebSocketSession session, TextMessage message) {
        session.sendMessage((WebSocketMessage)message);
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        String sessionId = session.getId();
        String userId = this.getUserId(session);
        logger.info("[PHOENIX-WS] websocket connection established: {} of u-{}", (Object)sessionId, (Object)userId);
        this.sessions.computeIfAbsent(sessionId, sid -> {
            this.userSessionIds.compute(userId, (uid, sids) -> sids == null ? sessionId : sids + "," + sessionId);
            return session;
        });
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        String sessionId = session.getId();
        String userId = this.getUserId(session);
        logger.info("[PHOENIX-WS] afterConnectionClosed u-{}", (Object)userId);
        this.userSessionIds.computeIfPresent(userId, (uid, sids) -> {
            String[] split = sids.split(",");
            ArrayList<String> strings = new ArrayList<String>(Arrays.asList(split));
            for (String sid : split) {
                if (!sessionId.equals(sid)) continue;
                this.sessions.remove(sid);
                strings.remove(sid);
            }
            return StringUtils.join(strings, (String)",");
        });
        logger.info("[PHOENIX-WS] websocket connection closed: {}", (Object)sessionId);
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        logger.trace("[PHOENIX-WS] message from websocket client: {}", (Object)message);
    }

    private String getUserId(WebSocketSession session) {
        UrlQuery queryParameters = HttpServletUtil.getQueryParameters(session.getUri());
        return queryParameters.get((CharSequence)URI_PARAM_USER_ID).toString();
    }
}

