package com.elitesland.cbpl.tool.es.service;

import cn.hutool.extra.servlet.ServletUtil;
import com.elitesland.cbpl.tool.core.date.DateUtils;
import com.elitesland.cbpl.tool.es.repository.ElasticsearchRepository;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

/**
 * @author eric.hao
 * @since 2023/06/13
 */
@Service
public class ElasticTrackServiceImpl implements ElasticTrackService {

    @Resource
    private ElasticsearchRepository elasticRepository;

    @Override
    public void addSystemLog(String indexName, String trackEvent, Object param, String eventError) {
        Map<String, Object> trackLog = new HashMap<>();
        trackLog.put("TRACK_TYPE", trackEvent);
        trackLog.put("CREATE_TIME", DateUtils.nowStr());
        trackLog.put("EVENT_PARAM", param);
        trackLog.put("EVENT_ERROR", eventError);
        elasticRepository.insert(trackLog, indexName);
    }

    @Override
    public void addTrackLog(HttpServletRequest request, String indexName, String trackEvent, Object param) {
        Map<String, Object> trackLog = new HashMap<>();
        trackLog.put("TRACK_TYPE", trackEvent);
        trackLog.put("CREATE_TIME", DateUtils.nowStr());
        trackLog.put("ADDRESS_IP", ServletUtil.getClientIP(request));
        trackLog.put("EVENT_PARAM", param);
        elasticRepository.insert(trackLog, indexName);
    }
}
