package com.elitesland.cbpl.tool.es.domain;

import lombok.Data;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.time.Instant;

/**
 * @author eric.hao
 * @since 2022/10/14
 */
@Data
public class TrackDoc {

    /**
     * 日志类型
     * {@link com.elitesland.cbpl.tool.es.domain.TrackEvent}
     */
    private String trackType;

    /**
     * 创建时间：格式字符串 yyyy-MM-dd HH:mm:ss
     */
    private String createTime;

    /**
     * 客户端IP
     */
    private String addressIp;

    /**
     * 业务记录的参数
     */
    private Object eventParam;

    /**
     * 错误信息
     */
    private String errorMessage;

    /**
     * 记录时间
     */
    @Field(name = "@timestamp", type = FieldType.Date, format = DateFormat.date_hour_minute_second_millis)
    private Instant timestamp = Instant.now();
}
