package com.elitesland.cbpl.tool.es.service;

import javax.servlet.http.HttpServletRequest;


/**
 * Event Tracking
 *
 * @author eric.hao
 * @since 2023/06/13
 */
public interface ElasticTrackService {

    /**
     * 添加系统日志
     *
     * @param indexName  索引
     * @param trackEvent 日志类型{@link com.elitesland.cbpl.tool.es.domain.TrackEvent}
     * @param param      业务参数
     * @param eventError 报错日志
     */
    void addSystemLog(String indexName, String trackEvent, Object param, String eventError);

    /**
     * 添加埋点日志
     *
     * @param request    客户端请求
     * @param indexName  索引
     * @param trackEvent 日志类型{@link com.elitesland.cbpl.tool.es.domain.TrackEvent}
     * @param param      业务参数
     */
    void addTrackLog(HttpServletRequest request, String indexName, String trackEvent, Object param);
}
