package com.elitesland.cbpl.tool.es.service;

import cn.hutool.extra.servlet.ServletUtil;
import com.elitesland.cbpl.tool.core.date.DateUtils;
import com.elitesland.cbpl.tool.es.domain.TrackDoc;
import com.elitesland.cbpl.tool.es.repository.ElasticsearchRepository;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * @author eric.hao
 * @since 2023/06/13
 */
@Service
public class ElasticTrackServiceImpl implements ElasticTrackService {

    @Resource
    private ElasticsearchRepository elasticRepository;

    @Override
    public void addSystemLog(String indexName, String trackEvent, Object param, String eventError) {
        TrackDoc trackDoc = new TrackDoc();
        trackDoc.setTrackType(trackEvent);
        trackDoc.setCreateTime(DateUtils.nowStr());
        trackDoc.setEventParam(param);
        trackDoc.setErrorMessage(eventError);
        elasticRepository.insert(trackDoc, indexName);
    }

    @Override
    public void addTrackLog(HttpServletRequest request, String indexName, String trackEvent, Object param) {
        TrackDoc trackDoc = new TrackDoc();
        trackDoc.setTrackType(trackEvent);
        trackDoc.setCreateTime(DateUtils.nowStr());
        trackDoc.setAddressIp(ServletUtil.getClientIP(request));
        trackDoc.setEventParam(param);
        elasticRepository.insert(trackDoc, indexName);
    }
}
