package com.elitesland.cbpl.tool.es.util;

import cn.hutool.core.text.StrPool;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.tool.core.date.DateUtils;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.IndexQueryBuilder;

/**
 * @author eric.hao
 * @since 2023/06/13
 */
public class ElasticsearchUtil {

    private static final String TENANT_SHORT_PREFIX = "_tenant_";

    /**
     * 根据类名，生成索引名称
     *
     * @param clazz    存储对象
     * @param tenantId 租户ID
     * @return 类名_tenant_id_年.月.日
     */
    public static String indexNameByClz(Class<?> clazz, String tenantId) {
        return indexNameByDay(StrUtil.toUnderlineCase(clazz.getSimpleName()), tenantId);
    }

    /**
     * 生成索引名称
     *
     * @param indexName 索引前缀
     * @param tenantId  租户ID
     * @return 前缀_tenant_id_年.月.日
     */
    public static String indexNameByDay(String indexName, String tenantId) {
        return indexName + TENANT_SHORT_PREFIX + tenantId + DateUtils.todayDot();
    }

    /**
     * 生成索引名称
     *
     * @param indexName 索引前缀
     * @return 前缀_年.月.日
     */
    public static String indexNameByDay(String indexName) {
        return indexName + StrPool.C_UNDERLINE + DateUtils.todayDot();
    }

    /**
     * 构建查询条件
     */
    public static <T> IndexQuery indexQueryBuilder(T row) {
        return new IndexQueryBuilder().withObject(row).build();
    }
}
