/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.tool.core.bean;

import cn.hutool.core.bean.BeanUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtils
extends BeanUtil {
    private static final Logger logger = LoggerFactory.getLogger(BeanUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static <T> T toBean(String source, Class<T> clazz) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(clazz);
        return (T)OBJECT_MAPPER.readValue(source, clazz);
    }

    public static <T> T toBean(Map<String, ?> source, Class<T> clazz) {
        return BeanUtils.toBean(BeanUtils.toJsonStr(source), clazz);
    }

    public static Map<String, Object> toMap(String source) {
        Objects.requireNonNull(source);
        return (Map)OBJECT_MAPPER.readValue(source, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static Map<String, Object> beanToMap(Object bean, String ... properties) {
        return BeanUtil.beanToMap((Object)bean, (String[])properties);
    }

    public static <T> List<T> toList(String source, Class<T> clazz) {
        return BeanUtils.toList(BeanUtils.toMapList(source), clazz);
    }

    public static <T> List<T> toList(List<Map<String, Object>> source, Class<T> clazz) {
        return source.stream().map(row -> BeanUtils.toBean(row, clazz)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T> List<T> toList(Object[] source, Class<T> clazz) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(clazz);
        return (List)OBJECT_MAPPER.readValue(BeanUtils.toJsonStr(source), new TypeReference<List<T>>(){});
    }

    public static List<String> toStrList(Object[] source) {
        return BeanUtils.toList(source, String.class);
    }

    public static List<Integer> toIntegerList(Object[] source) {
        return BeanUtils.toList(source, Integer.class);
    }

    public static List<Map<String, Object>> toMapList(String source) {
        Objects.requireNonNull(source);
        return (List)OBJECT_MAPPER.readValue(source, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
    }

    public static List<Map<String, Object>> toMapList(List<?> source) {
        Objects.requireNonNull(source);
        return (List)OBJECT_MAPPER.readValue(BeanUtils.toJsonStr(source), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
    }

    public static <T> String toJsonStr(T payload) {
        Objects.requireNonNull(payload);
        return OBJECT_MAPPER.writeValueAsString(payload);
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

