package com.elitesland.cloudt.context.flyway.support;

import com.elitesland.cloudt.context.flyway.FlywayCloudtProperties;
import lombok.extern.log4j.Log4j2;
import org.flywaydb.core.Flyway;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/23
 */
@Log4j2
public class FlywayHelper {

    private final FlywayCloudtProperties properties;

    public FlywayHelper(FlywayCloudtProperties properties) {
        this.properties = properties;
    }

    public void migrate(Supplier<Flyway> flywaySupplier) {
        try {
            flywaySupplier.get().migrate();
            return;
        } catch (Exception e) {
            log.error("升级脚本异常：", e);
            flywaySupplier.get().repair();
        }

        int times = 1;
        while (times < properties.getRetryTimes()) {
            try {
                TimeUnit.SECONDS.sleep(properties.getRetryInterval().getSeconds());

                log.info("重试升级脚本第{}次...", times);
                flywaySupplier.get().migrate();
                log.info("重试升级脚本第{}次成功！", times);

                return;
            } catch (Exception e) {
                log.error("升级脚本异常：", e);
            }
        }
    }
}
