package com.elitesland.cloudt.context.spi.support;

import java.lang.annotation.Annotation;

/**
 * Spi相关工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/2/17
 */
class SpiUtil {

    private SpiUtil() {
    }

    /**
     * 获取单一注解
     *
     * @param clazz      类
     * @param annotation 注解类型
     * @param <S>        注解类型
     * @return 注解
     */
    public static <S extends Annotation> S obtainAnnotationSingle(Class<?> clazz, Class<S> annotation) {
        var anno = clazz.getAnnotationsByType(annotation);
        return anno.length > 0 ? anno[0] : null;
    }
}
