package com.elitesland.cloudt.context.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

/**
 * 集合工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/01/05
 */
public class CollectionUtil {

    private CollectionUtil() {
    }

    /**
     * 拆分集合
     *
     * @param collection 原集合
     * @param size 每次拆分的大小
     * @param consumer 接收子集合的consumer
     * @param <E> 集合中元素类型
     */
    public static  <E> void split(List<E> collection, int size, Consumer<List<E>> consumer) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        size = Integer.max(1, size);

        int max = collection.size();
        if (size >= max) {
            consumer.accept(collection);
            return;
        }

        int index = 0;
        int tempMax = 0;
        List<E> sub = null;
        while (true) {
            tempMax = Integer.min(index + size, max);

            sub = new ArrayList<>(size);
            for (;index < tempMax; index ++) {
                sub.add(collection.get(index));
            }

            consumer.accept(sub);
            if (tempMax == max) {
                break;
            }
        }
    }
}
