/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.context.threadpool;

import com.dtp.common.config.DtpProperties;
import com.dtp.core.thread.DtpExecutor;
import com.elitesland.cloudt.context.threadpool.ThreadPoolHolder;
import com.elitesland.cloudt.context.threadpool.support.CustomTaskExecutor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.task.TaskExecutor;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={TaskExecutionAutoConfiguration.class})
public class ThreadPoolAutoConfiguration {
    private final DtpProperties dtpProperties;

    public ThreadPoolAutoConfiguration(DtpProperties dtpProperties) {
        this.dtpProperties = dtpProperties;
        ThreadPoolHolder.setDtpEnabled(dtpProperties.isEnabled());
    }

    @Bean(value={"taskExecutor"})
    @Primary
    public TaskExecutor taskExecutor() {
        return new CustomTaskExecutor(this.dtpProperties);
    }

    @Bean
    public DtpExecutor cloudtDefaultDtpExecutor() {
        return (DtpExecutor)ThreadPoolHolder.createThreadPool("cloudT-dtp-default", "cloudT-tp-", 8, 64);
    }
}

