/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.context.flyway;

import cn.hutool.core.lang.Assert;
import com.elitesland.cloudt.context.flyway.FlywayBuilder;
import com.elitesland.cloudt.context.flyway.FlywayCloudtProperties;
import com.elitesland.cloudt.context.flyway.support.FlywayHelper;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.flywaydb.core.Flyway;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="elitesland.flyway", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={FlywayCloudtProperties.class})
@ConditionalOnClass(value={Flyway.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, JdbcTemplateAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
@Import(value={FlywayAutoMigrate.class})
public class FlywayCloudtAutoConfiguration {
    private static final Logger log = LogManager.getLogger(FlywayCloudtAutoConfiguration.class);
    private final FlywayCloudtProperties properties;
    private final DataSource defaultDataSource;

    public FlywayCloudtAutoConfiguration(FlywayCloudtProperties properties, DataSource defaultDataSource) {
        this.properties = properties;
        this.defaultDataSource = defaultDataSource;
    }

    @Bean
    @ConditionalOnMissingBean
    public FlywayBuilder flywayBuilder(ObjectProvider<HikariConfig> hikariConfigObjectProvider) {
        DataSource dataSource = this.buildDataSource((HikariConfig)hikariConfigObjectProvider.getIfAvailable());
        return new FlywayBuilder(dataSource, this.properties);
    }

    @Bean
    public FlywayHelper flywayHolder() {
        return new FlywayHelper(this.properties);
    }

    private DataSource buildDataSource(HikariConfig defaultHikariConfig) {
        if (StringUtils.hasText((String)this.properties.getDbUrl())) {
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl(this.properties.getDbUrl());
            config.setDriverClassName((String)Assert.notBlank((CharSequence)this.properties.getDbDriverClassName(), (String)"dbDriverClassName\u4e3a\u7a7a", (Object[])new Object[0]));
            config.setUsername((String)Assert.notBlank((CharSequence)this.properties.getDbUser(), (String)"dbUser\u4e3a\u7a7a", (Object[])new Object[0]));
            config.setPassword((String)Assert.notBlank((CharSequence)this.properties.getDbPassword(), (String)"dbPassword\u4e3a\u7a7a", (Object[])new Object[0]));
            return new HikariDataSource(config);
        }
        if (defaultHikariConfig != null) {
            return defaultHikariConfig instanceof DataSource ? (DataSource)defaultHikariConfig : new HikariDataSource(defaultHikariConfig);
        }
        return this.defaultDataSource;
    }

    static class FlywayAutoMigrate
    implements ApplicationRunner {
        @Autowired
        private FlywayCloudtProperties flywayCloudtProperties;
        @Autowired
        private FlywayBuilder flywayBuilder;
        @Autowired
        private FlywayHelper flywayHelper;
        @Autowired
        private TaskExecutor taskExecutor;

        FlywayAutoMigrate() {
        }

        public void run(ApplicationArguments args) throws Exception {
            this.taskExecutor.execute(() -> {
                log.info("\u68c0\u67e5\u3010\u7cfb\u7edf\u3011\u6570\u636e\u5e93\u811a\u672c...");
                this.checkSysScript();
                log.info("\u68c0\u67e5\u3010\u7cfb\u7edf\u3011\u6570\u636e\u5e93\u811a\u672c\u7ed3\u675f");
            });
        }

        private void checkSysScript() {
            if (this.flywayCloudtProperties.getAutoMigrateAfterStart().isNegative() || this.flywayCloudtProperties.getAutoMigrateAfterStart().isZero()) {
                log.info("\u68c0\u67e5\u3010\u7cfb\u7edf\u3011\u6570\u636e\u5e93\u811a\u672c\u5ffd\u7565");
                return;
            }
            this.flywayHelper.migrate(this.flywayBuilder::createFlywayForSys);
        }
    }
}

