package com.elitesland.cloudt.context.threadpool;

import com.dtp.common.config.DtpProperties;
import com.dtp.core.thread.DtpExecutor;
import com.elitesland.cloudt.context.threadpool.support.CustomTaskExecutor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.task.TaskExecutor;

/**
 * 线程池相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/2/21
 */
@Configuration(proxyBeanMethods = false)
@AutoConfigureBefore(TaskExecutionAutoConfiguration.class)
public class ThreadPoolAutoConfiguration {

    private final DtpProperties dtpProperties;

    public ThreadPoolAutoConfiguration(DtpProperties dtpProperties) {
        this.dtpProperties = dtpProperties;

        ThreadPoolHolder.setDtpEnabled(dtpProperties.isEnabled());
    }

    @Bean("taskExecutor")
    @Primary
    public TaskExecutor taskExecutor() {
        return new CustomTaskExecutor(dtpProperties);
    }

    @Bean
    public DtpExecutor cloudtDefaultDtpExecutor() {
        return (DtpExecutor) ThreadPoolHolder.createThreadPool(CustomTaskExecutor.CLOUDT_DTP_DEFAULT, CustomTaskExecutor.CLOUDT_TP, 8, 64);
    }
}
