package com.elitesland.cloudt.context.redis;

import lombok.extern.log4j.Log4j2;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/4/11
 */
@Configuration(proxyBeanMethods = false)
@Log4j2
public class CloudtRedisConfiguration {

    @Bean
    @ConditionalOnMissingBean(RedisWrapper.class)
    public RedisWrapper redisWrapper() {
        return (callable, param) -> {
            try {
                return callable.call();
            } catch (Exception e) {
                log.error("redis调用失败", e);
                throw new RuntimeException("执行redis调用失败", e);
            }
        };
    }
}
