/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cloudt.context;

import com.elitesland.cloudt.context.base.AbstractEnvironmentPostProcessor;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.util.CollectionUtils;

@Order(value=-2147483648)
public class DefaultEnvironmentConfig
extends AbstractEnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MutablePropertySources propertySources = environment.getPropertySources();
        Map<String, Object> defaultProperties = this.createDefaultProperties(environment);
        if (!CollectionUtils.isEmpty(defaultProperties)) {
            this.addOrReplace(propertySources, defaultProperties);
        }
    }

    private Map<String, Object> createDefaultProperties(ConfigurableEnvironment environment) {
        HashMap<String, Object> defaultProperties = new HashMap<String, Object>(8);
        defaultProperties.put("spring.main.allow-circular-references", true);
        defaultProperties.put("spring.main.allow-bean-definition-overriding", true);
        defaultProperties.put("spring.flyway.enabled", false);
        return defaultProperties;
    }
}

