package com.elitesland.cloudt.context;

import com.elitesland.cloudt.context.base.AbstractEnvironmentPostProcessor;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * 默认环境变量配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/23
 */
@Order(Ordered.HIGHEST_PRECEDENCE)
public class DefaultEnvironmentConfig extends AbstractEnvironmentPostProcessor {

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MutablePropertySources propertySources = environment.getPropertySources();
        Map<String, Object> defaultProperties = createDefaultProperties(environment);
        if (!CollectionUtils.isEmpty(defaultProperties)) {
            addOrReplace(propertySources, defaultProperties);
        }
    }

    private Map<String, Object> createDefaultProperties(ConfigurableEnvironment environment) {
        Map<String, Object> defaultProperties = new HashMap<>(8);
        // 默认允许循环依赖
        defaultProperties.put("spring.main.allow-circular-references", true);
        // 允许bean重复定义
        defaultProperties.put("spring.main.allow-bean-definition-overriding", true);
        // 默认禁用springboot提供的flyway自动化配置，使用我们的自动化配置 {@link com.elitesland.cloudt.context.flyway.FlywayCloudtAutoConfiguration}
        defaultProperties.put("spring.flyway.enabled", false);

        return defaultProperties;
    }
}
