package com.elitesland.cloudt.context.flyway;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import lombok.extern.log4j.Log4j2;
import org.flywaydb.core.Flyway;

import javax.sql.DataSource;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/23
 */
@Log4j2
public class FlywayBuilder {

    private final DataSource dataSource;
    private final FlywayCloudtProperties properties;

    public FlywayBuilder(DataSource dataSource, FlywayCloudtProperties properties) {
        this.dataSource = dataSource;
        this.properties = properties;
    }

    /**
     * 默认系统
     *
     * @return
     */
    Flyway createFlywayForSys() {
        return Flyway.configure()
                .dataSource(dataSource)
                .locations(Assert.notBlank(properties.getLocationSys()))
                .baselineOnMigrate(true)
                .baselineVersion("1")
                .validateOnMigrate(true)
                .validateMigrationNaming(true)
                .load();
    }

    /**
     * 创建租户使用
     *
     * @param prefix schema前缀
     * @param schema 租户对应的schema
     * @return
     */
    public Flyway createFlywayForTenant(String prefix, String schema) {
        prefix = CharSequenceUtil.isBlank(prefix) ? "" : prefix + "_";
        return Flyway.configure()
                .dataSource(dataSource)
                .locations(properties.getLocationTenant())
                .schemas(prefix + schema)
                .baselineVersion("1")
                .validateOnMigrate(true)
                .validateMigrationNaming(true)
                .load();
    }
}
