package com.elitesland.cloudt.context.transaction;

import lombok.extern.log4j.Log4j2;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 自定义相关事务配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/4/7
 */
@Configuration(proxyBeanMethods = false)
@Log4j2
public class CustomTransactionAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean(value = TransactionWrapper.class)
    public TransactionWrapper defaultTransactionWrapper() {
        return (runnable, param) -> {
            try {
                return runnable.call();
            } catch (Exception e) {
                log.error("执行事务包装处理异常：", e);
                throw new RuntimeException(e);
            }
        };
    }
}
