package com.elitesland.cloudt.context.base;

import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

import java.util.Map;

/**
 * 环境变量处理.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/25
 */
public abstract class AbstractEnvironmentPostProcessor implements EnvironmentPostProcessor {

    // 自springboot 2.4开始增加该设置
//    private static final String PROPERTY_SOURCE_NAME = DefaultPropertiesPropertySource.NAME;
    private static final String PROPERTY_SOURCE_NAME = "defaultProperties";


    /**
     * Copy from BusEnvironmentPostProcessor#addOrReplace(MutablePropertySources, Map)
     *
     * @param propertySources {@link MutablePropertySources}
     * @param map             Default Dubbo Properties
     */
    protected void addOrReplace(MutablePropertySources propertySources,
                                Map<String, Object> map) {
        MapPropertySource target = null;
        if (propertySources.contains(PROPERTY_SOURCE_NAME)) {
            PropertySource<?> source = propertySources.get(PROPERTY_SOURCE_NAME);
            if (source instanceof MapPropertySource) {
                target = (MapPropertySource) source;
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    if (!target.containsProperty(entry.getKey())) {
                        target.getSource().put(entry.getKey(), entry.getValue());
                    }
                }
            }
        }
        if (target == null) {
            target = new MapPropertySource(PROPERTY_SOURCE_NAME, map);
        }
        if (!propertySources.contains(PROPERTY_SOURCE_NAME)) {
            propertySources.addLast(target);
        }
    }
}
