package com.elitesland.cloudt.context.flyway;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.time.Duration;

/**
 * flyway相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/23
 */
@ConfigurationProperties(prefix = FlywayCloudtProperties.CONFIG_PREFIX)
public class FlywayCloudtProperties {

    static final String CONFIG_PREFIX = "elitesland.flyway";

    /**
     * 是否启用
     */
    private boolean enabled = true;

    /**
     * 系统的数据库脚本目录
     */
    private String locationSys = "classpath:db/migration";

    /**
     * 租户相关的数据库脚本目录
     */
    private String locationTenant = "classpath:db/migration/tenants";

    /**
     * 数据库链接，为空时取系统的数据源
     */
    private String dbUrl;

    /**
     * 数据库驱动名称
     */
    private String dbDriverClassName;

    /**
     * 数据库用户名
     */
    private String dbUser;

    /**
     * 数据库密码
     */
    private String dbPassword;

    /**
     * 是否开启baseline
     */
    private boolean baselineOnMigrate = true;

    /**
     * baseline 版本，小于该版本的会忽略
     */
    private String baselineVersion = "1";

    /**
     * 系统启动后自动检查升级脚本，默认10秒后
     */
    private Duration autoMigrateAfterStart = Duration.ofSeconds(10);

    /**
     * 升级脚本失败后重试次数，默认3次
     */
    private int retryTimes = 3;

    /**
     * 失败后重试间隔，默认1分钟
     */
    private Duration retryInterval = Duration.ofMinutes(1);

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getLocationSys() {
        return locationSys;
    }

    public void setLocationSys(String locationSys) {
        this.locationSys = locationSys;
    }

    public String getLocationTenant() {
        return locationTenant;
    }

    public void setLocationTenant(String locationTenant) {
        this.locationTenant = locationTenant;
    }

    public String getDbUrl() {
        return dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public String getDbDriverClassName() {
        return dbDriverClassName;
    }

    public void setDbDriverClassName(String dbDriverClassName) {
        this.dbDriverClassName = dbDriverClassName;
    }

    public String getDbUser() {
        return dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public String getDbPassword() {
        return dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public boolean isBaselineOnMigrate() {
        return baselineOnMigrate;
    }

    public void setBaselineOnMigrate(boolean baselineOnMigrate) {
        this.baselineOnMigrate = baselineOnMigrate;
    }

    public String getBaselineVersion() {
        return baselineVersion;
    }

    public void setBaselineVersion(String baselineVersion) {
        this.baselineVersion = baselineVersion;
    }

    public Duration getAutoMigrateAfterStart() {
        return autoMigrateAfterStart;
    }

    public void setAutoMigrateAfterStart(Duration autoMigrateAfterStart) {
        this.autoMigrateAfterStart = autoMigrateAfterStart;
    }

    public int getRetryTimes() {
        return retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public Duration getRetryInterval() {
        return retryInterval;
    }

    public void setRetryInterval(Duration retryInterval) {
        this.retryInterval = retryInterval;
    }
}
