package com.elitesland.cloudt.context.threadpool.support;

/**
 * 上下文传播器.
 * <p>
 * 用于异步线程的上下文信息传递。实现该接口后注册为SpringBean即可
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/30
 */
public interface ContextTransfer<T> {

    /**
     * 获取上下文
     *
     * @return 上下文信息
     */
    T getContext();

    /**
     * 设置上下文信息
     *
     * @param context 上下文信息
     */
    void setContext(T context);

    /**
     * 清除上下文信息
     */
    void clearContext();
}
